#define _QCAP_LABVIEW_IMPORT
typedef int                 BOOL;
#define FALSE 0
#define TRUE 1
typedef int INT;
#include <QDebug>

#include "netreceiverdlg.h"
#include "ui_netreceiverdlg.h"

#include "QCAP.H"

QRETURN on_video_broadcast_client_callback( PVOID pClient, UINT iSessionNum, double dSampleTime, BYTE * pStreamBuffer, ULONG nStreamBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
    NetReceiverDlg * pNetReceiverDlg = (NetReceiverDlg *)(pUserData);

    pNetReceiverDlg->m_nNetworkVideoStreamSize += nStreamBufferLen;

    pNetReceiverDlg->m_nNetworkVideoFrames++;

    return QCAP_RT_OK;
}

QRETURN on_audio_broadcast_client_callback( PVOID pClient, UINT iSessionNum, double dSampleTime, BYTE * pStreamBuffer, ULONG nStreamBufferLen, PVOID pUserData )
{
    NetReceiverDlg * pNetReceiverDlg = (NetReceiverDlg *)(pUserData);

    pNetReceiverDlg->m_nNetworkAudioStreamSize += nStreamBufferLen;

    pNetReceiverDlg->m_nNetworkAudioFrames++;

    return QCAP_RT_OK;
}

QRETURN on_video_decoder_broadcast_client_callback( PVOID pClient, UINT iSessionNum, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
    NetReceiverDlg * pNetReceiverDlg = (NetReceiverDlg *)(pUserData);

//	qDebug( "on_video_decoder_broadcast_client_callback( %f, %d )", dSampleTime, nFrameBufferLen );

    pNetReceiverDlg->m_nNetworkVideoDecoderFrames++;

    return QCAP_RT_OK;
}

QRETURN on_audio_decoder_broadcast_client_callback( PVOID pClient, UINT iSessionNum, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
    NetReceiverDlg * pNetReceiverDlg = (NetReceiverDlg *)(pUserData);

//	qDebug( "on_audio_decoder_broadcast_client_callback( %f, %d )", dSampleTime, nFrameBufferLen );

    pNetReceiverDlg->m_nNetworkAudioDecoderFrames++;

    return QCAP_RT_OK;
}

QRETURN on_broadcast_client_connnected_callback( PVOID pClient, UINT iSessionNum, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
    return QCAP_RT_OK;
}

NetReceiverDlg::NetReceiverDlg(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::NetReceiverDlg)
{
    ui->setupUi(this);

    this->setMinimumSize(623,530);

    this->setMaximumSize(623,530);

    ui->lineEdit_URL->setText(QString("rtsp://root:root@127.0.0.1:554/session0.mpg"));

    ui->pushBTN_StopClient->setEnabled(false);

    ui->pushButton_StartRecord->setEnabled(false);

    ui->pushButton_StopRecord->setEnabled(false);

    ui->radioButton_TCP->setChecked(true);

    path = QCoreApplication::applicationDirPath();

    ui->lineEdit_RecordPath->setText( path + QString("/record_client.mp4"));

    CoInitialize( NULL );

    //INITIALIZE MEMBER VARIABLES

    m_bIsRecord = false;

    m_pNetworkReceiver = NULL;

    m_nNetworkVideoStreamSize = 0;

    m_nNetworkAudioStreamSize = 0;

    m_nNetworkVideoFrames = 0;

    m_nNetworkAudioFrames = 0;

    m_nNetworkVideoDecoderFrames = 0;

    m_nNetworkAudioDecoderFrames = 0;
}

NetReceiverDlg::~NetReceiverDlg()
{
    on_pushButton_StopRecord_clicked();

    on_pushBTN_StopClient_clicked();

    delete ui;
}

void NetReceiverDlg::on_pushBTN_StartClient_clicked()
{
    on_pushBTN_StopClient_clicked();

    m_pNetworkReceiver = NULL;

    m_nNetworkVideoStreamSize = 0;

    m_nNetworkAudioStreamSize = 0;

    m_nNetworkVideoFrames = 0;

    m_nNetworkAudioFrames = 0;

    m_nNetworkVideoDecoderFrames = 0;

    m_nNetworkAudioDecoderFrames = 0;

    QByteArray record1_path_ByteArray = ui->lineEdit_URL->text().toLocal8Bit();

    CHAR* psz = record1_path_ByteArray.data();

    //2014.10.16
    //
    QCAP_CREATE_BROADCAST_CLIENT( 0, psz, &m_pNetworkReceiver, QCAP_DECODER_TYPE_SOFTWARE, (HWND)ui->PreviewWindow->winId(), TRUE );

    QCAP_REGISTER_BROADCAST_CLIENT_CONNECTED_CALLBACK( m_pNetworkReceiver, on_broadcast_client_connnected_callback, this);

    QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK( m_pNetworkReceiver, on_video_broadcast_client_callback, this );

    QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK( m_pNetworkReceiver, on_audio_broadcast_client_callback, this );

    QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK( m_pNetworkReceiver, on_video_decoder_broadcast_client_callback, this );

    QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK( m_pNetworkReceiver, on_audio_decoder_broadcast_client_callback, this );

    if( ui->radioButton_UDP->isChecked() ) { QCAP_START_BROADCAST_CLIENT( m_pNetworkReceiver, QCAP_BROADCAST_PROTOCOL_UDP ); }

    if( ui->radioButton_TCP->isChecked() ) { QCAP_START_BROADCAST_CLIENT( m_pNetworkReceiver, QCAP_BROADCAST_PROTOCOL_TCP ); }

    if( ui->radioButton_HTTP->isChecked() ) { QCAP_START_BROADCAST_CLIENT( m_pNetworkReceiver, QCAP_BROADCAST_PROTOCOL_HTTP ); }

    m_nTimerId = startTimer(1000);

    ui->pushBTN_StartClient->setEnabled(false);

    ui->pushBTN_StopClient->setEnabled(true);

    ui->pushButton_StartRecord->setEnabled(true);
}

void NetReceiverDlg::on_pushBTN_StopClient_clicked()
{
    if( m_pNetworkReceiver != NULL)
    {
        on_pushButton_StopRecord_clicked();

        QCAP_STOP_BROADCAST_CLIENT( m_pNetworkReceiver );

        QCAP_DESTROY_BROADCAST_CLIENT( m_pNetworkReceiver );

        m_pNetworkReceiver = NULL;

        ui->pushBTN_StartClient->setEnabled(true);

        ui->pushBTN_StopClient->setEnabled(false);

        ui->pushButton_StartRecord->setEnabled(false);
    }
}

void NetReceiverDlg::on_pushButton_StartRecord_clicked()
{
    if( m_pNetworkReceiver != NULL )
    {
        on_pushButton_StopRecord_clicked();

        QByteArray record1_path_ByteArray = ui->lineEdit_RecordPath->text().toLocal8Bit();

        CHAR* psz = record1_path_ByteArray.data();

        QCAP_START_BROADCAST_CLIENT_RECORD( m_pNetworkReceiver, 0, psz);

        m_bIsRecord = true;

        ui->pushButton_StartRecord->setEnabled(false);

        ui->pushButton_StopRecord->setEnabled(true);
    }
}

void NetReceiverDlg::on_pushButton_StopRecord_clicked()
{
    if( m_bIsRecord == true )
    {
        QCAP_STOP_BROADCAST_CLIENT_RECORD( m_pNetworkReceiver, 0 );

        m_bIsRecord = false;

        ui->pushButton_StartRecord->setEnabled(true);

        ui->pushButton_StopRecord->setEnabled(false);
    }
}

void NetReceiverDlg::timerEvent( QTimerEvent *event )
{
    QString str_info;

    str_info.sprintf("VIDEO: %d KB (%d / %d)", (ULONG)(m_nNetworkVideoStreamSize / 1024), m_nNetworkVideoFrames, m_nNetworkVideoDecoderFrames);

    ui->label_video_info->setText( str_info );

    str_info.sprintf("AUDIO: %d KB (%d / %d)", (ULONG)(m_nNetworkAudioStreamSize / 1024), m_nNetworkAudioFrames, m_nNetworkAudioDecoderFrames);

    ui->label_audio_info->setText( str_info );
}
